import json
import peewee as pw
from datetime import datetime

db = pw.SqliteDatabase('opencdn.db')


class JSONField(pw.TextField):
    def db_value(self, value):
        return json.dumps(value, ensure_ascii=False)

    def python_value(self, value):
        if value is not None:
            return json.loads(value)
        return None


class BaseModel(pw.Model):
    class Meta:
        database = db

    id = pw.IntegerField(primary_key=True)
    created_at = pw.DateTimeField(default=datetime.now)
    updated_at = pw.DateTimeField(default=datetime.now)

    def save(self, *args, **kwargs):
        self.updated_at = datetime.now()
        return super().save(*args, **kwargs)