#!/bin/sh

set -e

echo 'Preparing start!'

# prepare packges
echo '--------------------'
echo 'install packages'
echo '--------------------'
apt-get update
apt-get install ufw nano mc htop iftop ca-certificates curl -y

# ufw
echo '--------------------'
echo 'install ufw'
echo '--------------------'
ufw allow 80
ufw allow 443
ufw allow 22
ufw --force enable
ufw default deny incoming

# docker
echo '--------------------'
echo 'install docker'
echo '--------------------'
install -m 0755 -d /etc/apt/keyrings
curl -fsSL https://download.docker.com/linux/ubuntu/gpg -o /etc/apt/keyrings/docker.asc
chmod a+r /etc/apt/keyrings/docker.asc
echo \
  "deb [arch=$(dpkg --print-architecture) signed-by=/etc/apt/keyrings/docker.asc] https://download.docker.com/linux/ubuntu \
  $(. /etc/os-release && echo "${UBUNTU_CODENAME:-$VERSION_CODENAME}") stable" | \
  sudo tee /etc/apt/sources.list.d/docker.list > /dev/null
apt-get update
apt-get install docker-ce docker-ce-cli containerd.io docker-buildx-plugin docker-compose-plugin -y

# Dockge
echo '--------------------'
echo 'install Dockge'
echo '--------------------'
mkdir -p /opt/stacks /opt/dockge
curl https://raw.githubusercontent.com/louislam/dockge/master/compose.yaml --output /opt/dockge/compose.yaml
docker compose -f /opt/dockge/compose.yaml up -d

# nginx
echo '--------------------'
echo 'install nginx'
echo '--------------------'
#apt install curl gnupg2 ca-certificates lsb-release ubuntu-keyring -y
#echo "deb http://nginx.org/packages/ubuntu `lsb_release -cs` nginx" \
#    | sudo tee /etc/apt/sources.list.d/nginx.list
#apt update
apt install nginx -y
systemctl enable --now nginx

# certbot
echo '--------------------'
echo 'install certbot'
echo '--------------------'
apt-get install python3-certbot-nginx -y

# nginxUI
echo '--------------------'
echo 'install nginxUI'
echo '--------------------'
bash -c "$(curl -L https://cloud.nginxui.com/install.sh)" @ install
ufw allow 9000

# info
echo '####################'
echo 'Preparing complete!'
echo '####################'

echo 'Please connect to server on http://ip:5001 to configure Dockge'
echo 'Please connect to server on http://ip:9000 to configure nginxUI, then close :9000 port using "ufw delete allow 9000"'
