#!/bin/sh

set -e

echo 'Preparing start!'

# prepare packges
echo '--------------------'
echo 'install packages'
echo '--------------------'
apt-get update
apt-get install ufw nano mc htop iftop ca-certificates curl -y


# nginx
echo '--------------------'
echo 'install nginx'
echo '--------------------'
#apt install curl gnupg2 ca-certificates lsb-release ubuntu-keyring -y
#echo "deb http://nginx.org/packages/ubuntu `lsb_release -cs` nginx" \
#    | sudo tee /etc/apt/sources.list.d/nginx.list
#apt update
apt install nginx -y
systemctl enable --now nginx

# certbot
echo '--------------------'
echo 'install certbot'
echo '--------------------'
apt-get install python3-certbot-nginx -y

# nginxUI
echo '--------------------'
echo 'install nginxUI'
echo '--------------------'
bash -c "$(curl -L https://cloud.nginxui.com/install.sh)" @ install
ufw allow 9000

# info
echo '####################'
echo 'Preparing complete!'
echo '####################'

echo 'Please connect to server on http://ip:9000 to configure nginxUI, then close :9000 port using "ufw delete allow 9000"'
