#!/bin/sh

set -e

echo 'Preparing start!'

# prepare packges
echo '--------------------'
echo 'install packages'
echo '--------------------'
apt-get update
apt-get install ufw nano mc htop iftop ca-certificates curl -y

# docker
echo '--------------------'
echo 'install docker'
echo '--------------------'
install -m 0755 -d /etc/apt/keyrings
curl -fsSL https://download.docker.com/linux/debian/gpg -o /etc/apt/keyrings/docker.asc
chmod a+r /etc/apt/keyrings/docker.asc

# Add the repository to Apt sources:
tee /etc/apt/sources.list.d/docker.sources <<EOF
Types: deb
URIs: https://download.docker.com/linux/debian
Suites: $(. /etc/os-release && echo "$VERSION_CODENAME")
Components: stable
Signed-By: /etc/apt/keyrings/docker.asc
EOF

apt update

apt install docker-ce docker-ce-cli containerd.io docker-buildx-plugin docker-compose-plugin -y


# Dockge
echo '--------------------'
echo 'install Dockge'
echo '--------------------'
mkdir -p /opt/stacks /opt/dockge
curl https://raw.githubusercontent.com/louislam/dockge/master/compose.yaml --output /opt/dockge/compose.yaml
docker compose -f /opt/dockge/compose.yaml up -d

# info
echo '####################'
echo 'Preparing complete!'
echo '####################'

echo 'Please connect to server on http://ip:5001 to configure Dockge'