/**
 * This function is called during the access token generation process to get custom claims for the access token.
 * Limit custom claims to under 50KB.
 *
 * @param {Payload} payload - The input argument of the function.
 * 
 * @returns The custom claims.
 */
const getCustomJwtClaims = async ({ token, context, environmentVariables, api }) => {
  const user = context.user;

  // const roles = user.roles.map((r) => r.name);

  const scopes = user.roles
    .map((r) => r.scopes.map((s) => s.name))
    .reduce((acc, val) => acc.concat(val), []);

  // const organizations = await Promise.all(
  //   user.organizations.map(async (org) => {
  //     // Find roles assigned to user in this org
  //     const orgRoles = user.organizationRoles.filter((or) => or.organizationId === org.id);

  //     // For each org role, fetch detailed scopes from Logto API
  //     const detailedRoles = await Promise.all(
  //       orgRoles.map(async (or) => {
  //         try {
  //           const roleData = await api.getRole(or.roleId);
  //           // Extract scopes from roleData
  //           const roleScopes = roleData.scopes.map((s) => s.name);

  //           return {
  //             id: or.roleId,
  //             name: or.roleName,
  //             scopes: roleScopes,
  //           };
  //         } catch (error) {
  //           // Handle error or return empty scopes
  //           return {
  //             id: or.roleId,
  //             name: or.roleName,
  //             scopes: [],
  //           };
  //         }
  //       })
  //     );

  //     return {
  //       id: org.id,
  //       name: org.name,
  //       roles: detailedRoles,
  //     };
  //   })
  // );

  return {    
    // user_id: user.id,
    // email: user.primaryEmail,
    // name: user.name,
    // suspended: user.isSuspended,
    // avatar: user.avatar,
    scopes
    // roles,
    // organizations,
  };
};